
(*$f+*)

program GRAPHER (input, output);

uses
   crt, CAL, graph;

var
    x, y                         : real;
    GraphicsDriver, Graphicsmode : integer;
    Temp, Interim                : string;
    Tekst                        : string;
    buffer                       : array[-1..4007] of shortint;
    oldx, oldy                   : longint;
    P                            : integer;
    Ch                           : char;
    QUIT                         : boolean;

const
    InsertOn : boolean = true;

var
    UpKey, DownKey, PageUp, PageDown : boolean;

procedure EGAVGADriver; external;
    {$L EGAVGA.OBJ}

procedure Print (x, y : integer; Tekst : string);
  label
      PrintAnyWay;
  var
      c, Len, yplus : integer;
      OldStyle      : textsettingstype;
  begin
     c:= 1;
     Len:= length (Tekst);
     gettextsettings (OldStyle);
     if OldStyle.Font = defaultfont then
         yplus:= 11
              else
                  yplus:= 0;
     repeat
         case Tekst[c] of
            '\': begin
                c:= c+1;
                case (upcase (Tekst[c])) of
                   '\': goto PrintAnyWay;
                   'T': begin
                       settextstyle (triplexfont, horizdir, 1);
                       yplus:= 0;
                   end;
                   'G': begin
                       settextstyle (gothicfont, horizdir, 1);
                       yplus:= 0;
                   end;
                   'D': begin
                       settextstyle (defaultfont, horizdir, 1);
                       yplus:= 11;
                   end;
                   'S': begin
                       settextstyle (sansseriffont, horizdir, 1);
                       yplus:= 0;
                   end;
                end;
            end;
            else begin
               PrintAnyWay:;
               outtextxy (x,y+yplus, Tekst[c]);
               inc (x, textwidth (Tekst[c]));
               if x > getmaxx then begin
                  x:= 0;
                  if y+17 < getmaxy then begin
                    y:= y+17;
                  end;
               end;
            end;
         end;
         c:= c+1;
     until c > Len;
  end;

procedure INPUT (X, Y : integer; var Tekst : string; Width : integer);
  var
     Ch     : char;
     XPlus,j: integer;
  begin
     XPLus:= length(Tekst);
     UpKey:= false;
     DownKey:= false;
     PageUp:= false;
     PageDown:= false;
     repeat
         repeat
             setfillstyle (solidfill, lightgray);
             setcolor (lightgray);
             bar (X, Y, X+(Width+1)*textwidth ('H'), Y+13);
             setcolor (white);
             outtextxy (X, Y, copy (Tekst, 1, Width));
             setfillstyle (solidfill, lightgray);
             setcolor (red);
             outtextxy (X+(XPlus)*textwidth ('H'), Y, #177);
             delay (33);
         until keypressed;
         Ch:= readkey;
         case Ch of
             #0: begin
                 Ch:= readkey;
                 case Ch of
                    'K': if XPlus > 0 then dec (XPLus, 1);
                    'M': if XPlus < Width then inc (XPlus, 1);
                    'S': if XPLus >= 1 then begin
                        delete (Tekst, XPLus+1, 1);
                    end else if XPlus = 0 then
                        delete (Tekst, 1, 1);
                    'R': InsertOn:= not InsertOn;
                    'G': XPlus:= 0;
                    'O': XPlus:= length (Tekst);
                    'H': UpKey:= true;
                    'P': DownKey:= true;
                    'I': PageUp:= true;
                    'Q': PageDown:= true;
                 end;
                 directvideo:= false;
             end;
             #8: begin
                 delete (Tekst, XPlus, 1);
                 if XPlus > 0 then XPlus:= XPlus - 1;
             end;
             else begin
                 case InsertOn of
                     true: if XPlus < Width then insert (Ch, Tekst, X+XPlus+1);
                     false: begin
                         if XPlus+1 > length(Tekst) then begin
                            for j:= length(Tekst) to XPlus do
                                if XPLus+1 < Width then
                                    Tekst:= concat (Tekst, #32);
                         end;
                         if XPlus < Width then Tekst[XPlus+1]:= Ch;
                     end;
                 end;
                 if XPlus < Width then
                     XPLus:= XPlus + 1;
             end;
         end;
     until (Ch in [#27, #13]) or UpKey or DownKey or PageUp or PageDown;
  end;

function UpString (Tekst : string) : string;
    var
        c : integer;
    begin
        for c:= 1 to length (Tekst) do begin
            Tekst[c]:= upcase (Tekst[c])
        end;
        UpString:= Tekst
    end;


begin
    nosound;
    if registerbgidriver (@EGAVGADriver) < 0 then halt(1);
    move (mem[$b800:$0000], buffer[0], 4000);
    oldx:= wherex;
    oldy:= wherey;
    GraphicsDriver:= vga;
    GraphicsMode:= vgahi;
    initgraph (GraphicsDriver, GraphicsMode, '');
    repeat
       setcolor (cyan);
       Print (3, 3, 'Write the equasion with two unknowns x and y to plot.');
       setcolor (white);
       Print (7, 17, 'y= ');
       Tekst:= '';
       setcolor (yellow);
       Input (7+3*8, 37, Tekst, 57);
       Tekst:= UpString (Tekst);
       X:= -8*pi;
       repeat
           Temp:= Tekst;
           P:= pos ('X', Temp);
           while (P > 0) do begin
              delete (Temp, P, 1);
              str (X, Interim);
              insert (Interim, Temp, P);
              P:= pos ('X', Temp);
           end;
           Y:= Evaluate0(Temp);
           putpixel (getmaxx div 2+round(X*11), getmaxy div 2+round(Y*11), red);
           sound (round(y)*111);
           x:= x + 0.17;
       until X > 8*PI;
       nosound;
       outtextxy (0, getmaxy-17, 'Again [y/n]?');
       repeat
           Ch:= readkey
       until Ch in ['y', 'Y', 'n', 'N'];
       QUIT:= Ch in ['n', 'N'];
       cleardevice
    until QUIT;
    textmode (co80);
    textbackground (black);
    textcolor (lightgray);
    clrscr;
    move(buffer[0], mem[$b800:$0000], 4000);
    gotoxy (oldx, oldy)
end.