/*
'Ed Davis. Tiny Basic that can play Star Trek
'Supports: end, list, load, new, run, save
'gosub/return, goto, if, input, print, multi-statement lines (:)
'a single numeric array: @(n), and rnd(n)

On Linux: gcc int-stc2.c.c -lm -o int-stc2
*/
#include <ctype.h>
#include <math.h>
#include "stdbool.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <conio.h>
#include <graphics.h>
#include <dos.h>

#ifndef CLK_TCK
    #define CLK_TCK CLOCKS_PER_SEC
#endif

#define NELEMS(arr) (sizeof(arr) / sizeof(arr[0]))

#define streql(s1, s2) (strcmp(s1, s2) == 0)
#define strneq(s1, s2) (strcmp(s1, s2))

enum {c_maxlines = 477, c_at_max = 1301, c_maxvars = 537, c_g_stack = 107};
typedef enum {tNONE,
    tPOUND='#',
    tLP='(',
    tRP=')',
    tMUL='*',
    tPLUS='+',
    tCOMMA=',',
    tMINUS='-',
    tDIV='/',
    tCOLON=':',
    tSEMICOLOR=';',
    tLT='<',
    tEQUAL='=',
    tGT='>',
    tQUESTION='?',
    tAMPERSAND='@',
    tBACKSLASH='\\',
    tHAT='^',
    tNEQ=256, tLEQ, tGEQ,
    tABS, tBYE, tAND, tASC, tCLEAR, tCLS, tEND, tFOR, tGOSUB, tGOTO, tHELP, tIDENT,
    tIF, tIFSTREQ, tIFSTRSMALLER, tIFSTRBIGGER, tIFSTRNOTEQ,
    tINPUT, tINPUTSTR, tIRND, tRANDOMISE, tLET, tLETSTR,
    tLIST, tLOAD, tMOD, tNEW, tNEXT, tNOT, tNUMBER, tOR,
    tPRINT, tPRINTSTR, tPRINTCHR, tMIDSTR, tLEFTSTR, tRIGHTSTR,
    tQUIT, tREM, tRETURN, tRND, tRUN, tSAVE, tSGN, tSTOP, tSTRING, tTHEN, tTO, tTROFF,
    tTRON, tSCREEN, tCIRCLE, tRECTANGLE,
    tELLIPSE, tLINE, tPLOT, tINK, tPAPER, tFILL,
    tREADKEY, tINKEY, tBEEP, tPAUSE, tOPEN, tCLOSE, tREAD, tWRITE, tLPRINT,
    tSEGMENT, tPOKE, tPEEK, tLOCATE
} tok_t;

bool screenisvga;
tok_t tok;
int num;
unsigned textp;
char texttok[1024];
char *thelin, thech;
char *pgm[c_maxlines+1];
int curline;
bool errors, tracing, need_colon;
int gsp;
int gstackln[c_g_stack];    // gosub line stack
int gstacktp[c_g_stack];    // gosub textp stack
clock_t timestart;

int vars[c_maxvars+1];
char strvars[c_maxvars+1][55];
char varname[c_maxvars+1][21];
int varptr = -1;
FILE *textfile[53];
int fileptr = -1;

int atarry[c_at_max];

int forvar[c_maxvars];
int forlimit[c_maxvars];
int forline[c_maxvars];
int forpos[c_maxvars];

bool  accept(tok_t s);
void _peek(void);
void _poke(void);
void randomizestmt (void);
void inputstrstmt (void);
void printstrstmt (void);
void printchrstmt (void);
void midstrstmt(void);
void leftstrstmt(void);
void rightstrstmt(void);
void rectanglestmt(void);
void openstmt (void);
void closestmt (void);
void readstmt (void);
void writestmt (void);

//void ifstreqstmt(void);
//void ifstrsmallerstmt(void);
//void ifstrbiggerstmt(void);
//void ifstrnoteqstmt(void);
void readkeystmt(void);
void inkeystmt(void);
void beepstmt(void);
void pausestmt(void);
void locatestmt(void);
void  arrassn(void);
void  assign(void);
void letstr(void);
void  clearvars(void);
void  docmd(void);
bool  expect(tok_t s);
int   expression(int minprec);
void  forstmt(void);
void  _getch(void);
char *getfilename(char action[]);
int   getvarindex(void);
void  gosubstmt(void);
void  gotostmt(void);
void  help(void);
void  ifstmt(void);
void  initlex(int n);
void  initlex2(void);
void  inputstmt(void);
void  liststmt(void);
void  loadstmt(void);
char *mygetline(FILE *fp);
void  newstmt(void);
void  nextstmt(void);
void  nexttok(void);
int   parenexpr(void);
void  printstmt(void);
void  readident(void);
void  readint(void);
void  readstr(void);
void  returnstmt(void);
void screenstmt(void);
void circlestmt(void);
void ellipsestmt(void);
void linestmt(void);
void plotstmt(void);
void inkstmt(void);
void paperstmt(void);
void fillstmt(void);
int   rnd(int range);
void  runstmt(void);
void  savestmt(void);
void  showtime(bool running);
void  skiptoeol(void);
bool  validlinenum(void);

void printer(char* s) {
   int x, y, oldcolour, c4;

   directvideo = false;
//   if (screenisvga == true) {
//      settextstyle (SMALL_FONT, HORIZ_DIR, 3);
//      oldcolour = getcolor();
//      setcolor(getbkcolor());
//      x = (wherex()-1)*textwidth("H");
//      y = (wherey()-1)*textheight("G");
//      for (c4=x; c4<x+textwidth(s); c4++) {
//	 line (c4,y, c4,y+textheight("H"));
//      }
//      setcolor (oldcolour);
//      outtextxy (x+1,y+1, s);
//      gotoxy (1, wherey()+2);
//   } else {
      cprintf ("%s", s);
      printf ("\n");
//   }
}

char* lcasestring (char* tekst) {
    int c;

    for (c=0; c<strlen(tekst); c++) {
	tekst[c] = tolower(tekst[c]);
    }
    return (tekst);
}

int pos (char* tekst, char* substring) {
   int c, c2;
   bool gelijk = false;

   for (c=0; c<strlen(tekst)-strlen(substring); c++) {
      gelijk = true;
      for (c2=0; c2<c+strlen(substring); c2++) {
	 if (tekst[c+c2] != substring[c2]) {
	    gelijk = false;
	 }
	 if (gelijk == true) return (c);
      }
   }
   return (0);
}

char* replace (char* tekst, char* old, char* newtekst) {
   int n, c;
   char temp[255];

   n = pos (tekst, old);
   strcpy (temp, "");
   strncpy (temp, tekst, n-1);
   strcat (temp, newtekst);
   for (c=strlen(temp)+1; c<strlen(tekst); c++) {
      temp[c]=tekst[c];
   }
   temp[c] = '\0';
   return (temp);
}

void mirrorString(char* str) {
    int start = 0;
    int end = strlen(str) - 1;
    char temp;

    while (start < end) {
	// Swap characters
	temp = str[start];
	str[start] = str[end];
	str[end] = temp;

	// Move pointers
	start++;
	end--;
    }
}

void insertSubstring(char *mainStr, char *subStr, int pos) {
    char result[100]; // Ensure this is large enough to hold the final string
    int mainLen = strlen(mainStr);
    int subLen = strlen(subStr);

    // Copy the first part of the main string
    strncpy(result, mainStr, pos);
    result[pos] = '\0';

    // Add the substring
    strcat(result, subStr);

    // Add the remaining part of the main string
    strcat(result, mainStr + pos);

    // Copy the result back to the main string
    strcpy(mainStr, result);
}

void _delete (char* tekst, int p, int l) {
     int c, c2;
     char temp[255];

     c2 = 0;
     for (c=p; c<= p+l; c++) {
	temp[c2] = tekst[c];
	c2++;
     }
     temp[c2] = '\0';
     strcpy (tekst, temp);
}

/*char* workout (char* tekst) {    // translates certain normal basic structures 2 expanded tinybasic
   int n, c,c2, a,b;
   char interim[255], tekst2[255];


   strcpy (tekst, lcasestring(tekst));
   n = pos(tekst, ":");
   while (n > 0) {
       insertSubstring (tekst, " ", n-1);
       insertSubstring (tekst, " ", n+2);
       n = pos(tekst, ":");
   }

   strcpy (tekst2, tekst);

   n  = pos (tekst2, "inkey");
   if (n>=0) {
      n = pos (tekst2, "=");
      strcpy (interim, "");
      c2=0;
      do {
	 n--;
	 interim[c2] = tekst2[n];
	 c2++;
      } while ((n >= 0) || (tekst2[n] != ' '));
      interim[c2] = '\0';
      mirrorString (interim);
      a = pos (tekst2, "inkey");
      b = pos (tekst2, interim);
      _delete (tekst2, b, b+a-1+5);
      insertSubstring (tekst2, "inkey ", b);
      a = pos (tekst2, "inkey ");
      insertSubstring (tekst2, interim, a+6);
   }
}
*/

    bool insert, up, down, Escape, F9, quit; // quit == Enter-key }

char *inputline (int a, int b, char *tekst, int xpos, int width) {
   char ch;
   char tekst0[257];
   int c;

   quit = false;
   up   = false;
   down = false;
   do {
       gotoxy (a, b);
       textbackground (LIGHTGRAY);
       textcolor (RED);
       gotoxy (a, b);
       for (c=a; c<a+width; c++) {
	  gotoxy (c, b);
	  cprintf ("%c", 32);
       }
       gotoxy (a, b);
       textbackground (LIGHTGRAY);
       textcolor (RED);
       cprintf ("%s", tekst);
       gotoxy (a+xpos, b);
       ch = getch();
       if (ch == 0) {
	  ch = getch();
	  if (ch == 'K') {
	     if (xpos > 0) { xpos--; }
	  } else
	  if (ch == 'M') {
	     if (xpos < width) { xpos++; }
	  } else
	  if (ch == 'H') {
	     up = true;
	  } else
	  if (ch == 'P') {
	    down = true;
	  } else
	  if (ch == 'C') {
	      F9 = true;
	  }
       } else
       if (ch == 8) {
	  if (xpos > 0) xpos--;
	  strncpy (tekst0, tekst, xpos);
	  for (c=xpos; c<strlen(tekst); c++) {
	     tekst0[c] = tekst[c+1];
	  }
	  tekst0[c] = '\0';
	  strcpy (tekst, tekst0);
       } else
       if (ch == 13) {
	  quit = true;
       } else
       if (ch == 27) {
	  Escape = true;
	  quit = true;
       } else {
	  if (insert == true) {
	     strcpy (tekst0, tekst);
	     tekst0[xpos] = ch;
	     for (c=xpos+1; c<=strlen (tekst)+1; c++) {
		tekst0[c] = tekst[c-1];
	     }
	     tekst0[c] = '\0';
	     strcpy (tekst, tekst0);
	     if (xpos < width) { xpos++; }
	  } else {
	     tekst[xpos] = ch;
	     if (xpos < width) xpos++;
	  }
       }
   } while ((Escape ==  false) && (quit == false) && (up == false) && (down == false) && (F9 == false));
   return (tekst);
}

void edit(void) {
   int horizon, y, x, c, n, m;
   char tekst[c_maxlines][87];
   char ch;

   int i;
   char filename[27];
   FILE *fp;

   horizon = 0;
   y = 1;
   x = 1;
   screenisvga = false;
   textmode (C80);
   for (c=0; c<c_maxlines; c++) {
      strcpy (tekst[c], "");
   }
   do {
     Escape = false;
     F9     = false;
     do {
	if (screenisvga==true) closegraph();
	textmode (C80);
	textbackground (LIGHTGRAY);
	textcolor (RED);
	clrscr();
	textbackground (BLUE);
	textcolor (WHITE);
	gotoxy (1, 1);
	cprintf ("%s", "F1 == help   F9 == run   F2==save  F3===load  [Esc]ape == quit TinyBasicExpanded");
	textbackground (LIGHTGRAY);
	textcolor (RED);
	for (c=1; c<22; c++) {
	  gotoxy (1, c+1);
	  cprintf ("%s", tekst[c+horizon]);
	}
	strcpy (tekst[y+horizon], strdup(inputline (1, y+1, tekst[y+horizon], strlen (tekst[y+horizon]), 80)));
	if (up == true) {
	   if (y > 1) y--; else
	   if (horizon > 0) horizon--;
	} else
	if ((down == true) || (quit == true)) {
	   if (y<22) y++; else
	   if ((horizon+y) < c_maxlines) horizon++;
	} else
	if (F9 == true) {
	  if (screenisvga==true) closegraph();
	  textmode(C80);
	  textbackground (BLACK);
	  textcolor (LIGHTGRAY);
	  clrscr();
	  screenisvga = false;
	  for (n=0; n<c_maxlines; n++) {
	      errors = false;
	      if (pgm[0]) free(pgm[0]);
	      pgm[0] = malloc (91);
	      strcpy (pgm[0], tekst[n]);
	      if (pgm[0] && pgm[0][0] != '\0') {
		  initlex(0);
		  if (tok == tNUMBER) {
		      if (validlinenum())
			  pgm[num] = strdup(pgm[0] + textp);
		  } else
		      docmd();
	      }
	  }
	  curline = 0;
	  screenisvga = false;
	  errors = false;
	  tok = tRUN;
	  docmd();
	  gotoxy (1, 22);
	  directvideo = false;
	  printf ("Press any key to return to the editor.... ... .....");
	  getch();
	  if (screenisvga==true) closegraph();
	  F9 = false;
	  Escape = false;
	  for (c=1; c<c_maxlines; c++) {
	     free (pgm[c]);
	  }
	}
     } while (Escape == false);
     textbackground (MAGENTA);
     textcolor (YELLOW);
     gotoxy (1, 24);
     cprintf ("Really quit TinyBasicExpanded? [y/n] .... ... ....");
     do {
	ch = getch();
     } while ((ch != 'Y') && (ch != 'y') && (ch != 'N') && (ch != 'n'));
   } while ((ch != 'Y') && (ch != 'y'));
}

int main(int argc, char *argv[]) {
//    int c;

//    char tekst[255];

    insert = true;
//    strcpy (tekst, "Testing 123 .... ");
//    xpos = 0;
//    strcpy (tekst, inputline (1,1, tekst, xpos, 80));

    nosound();

//    new (vars);
//    for (c=0; c<= c_maxvars; c++) {
//	strvars[c] = (char *) malloc (255);
//	varname[c] = (char *) malloc (21);
//    }
    screenisvga = false;
    textmode (C80);
    directvideo = false;
    textbackground (BLACK);
    textcolor (LIGHTGRAY);
    clrscr();
    if (argc > 1) {
	tok = tSTRING;
	sprintf(texttok, "\"%s", argv[1]);
	loadstmt();
	tok = tRUN;
	docmd();
    } else {
	newstmt();
    }
    help();
    printf ("\n");
    newstmt();
    errors= false;
    initlex(0);
//    edit();
    for (;;) {
	errors = false;
	gotoxy (1, wherey());
	printf("c> ");
	if (pgm[0]) free(pgm[0]);
	pgm[0] = mygetline(stdin);
//	strcpy (*pgm[0], workout (pgm[0]));
	if (pgm[0] && pgm[0][0] != '\0') {
	    initlex(0);
	    if (tok == tNUMBER) {
		if (validlinenum())
		    pgm[num] = strdup(pgm[0] + textp);
	    } else
		docmd();
	}
    }
//    for (c=0; c<= c_maxvars; c++) {
//	free(strvars[c]);
//	free(varname[c]);
//    }

    return (0);
}

void docmd(void) {
    bool running = false;
    for (;;) {
	need_colon = true;
	if (tracing && tok != tCOLON && thelin && textp < strlen(thelin))
	    printf("\n[%d] %s\n", curline, &thelin[textp - 1]);
	if        (tok == tBYE || tok == tQUIT) { nexttok(); exit(0);
	} else if (tok == tEND || tok == tSTOP) { nexttok(); showtime(running); return;
	} else if (tok == tCLEAR)     { nexttok(); clearvars(); return;
	} else if (tok == tHELP)      { nexttok(); help(); return;
	} else if (tok == tLIST)      { nexttok(); liststmt(); return;
	} else if (tok == tLOAD)      { nexttok(); loadstmt(); return;
	} else if (tok == tNEW)       { nexttok(); newstmt(); return;
	} else if (tok == tRUN)       { nexttok(); runstmt(); running = true; need_colon = false;
	} else if (tok == tSAVE)      { nexttok(); savestmt(); return;
	} else if (tok == tTRON)      { nexttok(); tracing = true;
	} else if (tok == tTROFF)     { nexttok(); tracing = false;
	} else if (tok == tCLS)       { nexttok(); if (screenisvga==true) { cleardevice();
	   directvideo = false; gotoxy(1, 1);} else { clrscr(); }; directvideo = false;
	} else if (tok == tFOR)       { nexttok(); forstmt();
	} else if (tok == tGOSUB)     { nexttok(); gosubstmt();
	} else if (tok == tGOTO)      { nexttok(); gotostmt();
	} else if (tok == tIF)        { nexttok(); ifstmt();
	} else if (tok == tINKEY)     { nexttok(); inkeystmt();
	} else if (tok == tREADKEY)   { nexttok(); readkeystmt();
	} else if (tok == tBEEP)      { nexttok(); beepstmt();
	} else if (tok == tPAUSE)     { nexttok(); pausestmt();
	} else if (tok == tOPEN)      { nexttok(); openstmt();
	} else if (tok == tCLOSE)     { nexttok(); closestmt();
	} else if (tok == tREAD)      { nexttok(); readstmt();
	} else if (tok == tWRITE)     { nexttok(); writestmt();
//	} else if (tok == tIFSTREQ)   { nexttok(); ifstreqstmt();
//	} else if (tok == tIFSTRSMALLER)   { nexttok(); ifstrsmallerstmt();
//	} else if (tok == tIFSTRBIGGER)   { nexttok(); ifstrbiggerstmt();
//	} else if (tok == tIFSTRNOTEQ)   { nexttok(); ifstrnoteqstmt();
	} else if (tok == tINPUT)     { nexttok(); inputstmt();
	} else if (tok == tINPUTSTR)  { nexttok(); inputstrstmt();
	} else if (tok == tNEXT)      { nexttok(); nextstmt();
	} else if (tok == tLET)       { nexttok(); assign();
	} else if (tok == tPEEK)      { nexttok(); _peek();
	} else if (tok == tPOKE)      { nexttok(); _poke();
	} else if (tok == tRANDOMISE) { nexttok(); randomizestmt();
	} else if (tok == tLETSTR)    { nexttok(); letstr();
	} else if (tok == tPRINT || tok == tQUESTION) { nexttok(); printstmt();
	} else if (tok == tPRINTSTR)  { nexttok(); printstrstmt();
	} else if (tok == tPRINTCHR)  { nexttok(); printchrstmt();
	} else if (tok == tMIDSTR)    { nexttok(); midstrstmt();
	} else if (tok == tLEFTSTR)   { nexttok(); leftstrstmt();
	} else if (tok == tRIGHTSTR)  { nexttok(); rightstrstmt();
	} else if (tok == tRETURN)    { nexttok(); returnstmt();
	} else if (tok == tSCREEN)    { nexttok(); screenstmt();
	} else if (tok == tCIRCLE)    { nexttok(); circlestmt();
	} else if (tok == tRECTANGLE) { nexttok(); rectanglestmt();
	} else if (tok == tELLIPSE)   { nexttok(); ellipsestmt();
	} else if (tok == tLINE)      { nexttok(); linestmt();
	} else if (tok == tPLOT)      { nexttok(); plotstmt();
	} else if (tok == tINK)       { nexttok(); inkstmt();
	} else if (tok == tPAPER)     { nexttok(); paperstmt();
	} else if (tok == tFILL)      { nexttok(); fillstmt();
	} else if (tok == tLOCATE)    { nexttok(); locatestmt();
	} else if (tok == tAMPERSAND) { nexttok(); arrassn();
	} else if (tok == tIDENT)     { assign();
	} else if (tok == tCOLON || tok == tNONE) { /* handled below */
	} else {
	    printf("(%d, %d) Unknown token: line: %s\n", curline, textp, pgm[curline]);
	    errors = true;
	}

	if (errors) return;
	if (tok == tNONE) {
	  while (tok == tNONE) {
	      if (curline == 0 || curline >= c_maxlines) { showtime(running); return;}
	      initlex(curline + 1);
	  }
	} else if (tok == tCOLON) { nexttok();
	} else if (need_colon && !expect(tCOLON)) { return;
	}

    }
}

void showtime(bool running) {
    if (running) {
	clock_t tt = clock() - timestart;
	printf("\nTook %.2f seconds\n", (float)(tt)/(float)CLK_TCK);
    }
}

void help(void) {
   sound (3333);
   delay (177);
   sound (1777);
   delay (233);
   nosound();
   puts("--------------Expanded Tiny Basic, written in Turbo C++  -------------");
   puts("| bye, clear, cls, end/stop, help, list, load/save, new, run, tron/off,|");
   puts("| randomise; beep <var>, <var>; pause <var>				|");
   puts("| for <var> = <expr1> to <expr2> ... next <var>                        |");
   puts("| gosub <expr> ... return                                              |");
   puts("| goto <expr>                                                          |");
   puts("| if <expr> then <statement>                                           |");
   puts("| input [prompt,] <var>; inputstr <str_num>, letstr <str_num>,\"....\"|");
   puts("| printstr <str_num>; <str_num> == 0..137; printchr <ascii_code>       |");
   puts("| poke <segment>,<offset>,<byte>; peek <var> = <segment>,<offset>      |");
   puts("| screen 11 -> vga640x480x16, screen 13-> mcga 320x200x256,screen 3:txt|");
   puts("| circle x,y,r; ellipse x,y,r1,r2; line x1,y1, x2,y2; fill x,y         |");
   puts("|     plot x,y; ink <var>; paper <var>; rectangle x1,y1, x2,y2         |");
   puts("| inkey <num_var>, e.g.: 100 inkey key:if key = -1 then goto 100       |");
   puts("| readkey <num_var>: no keypress no continue.... ... ....	        |");
   puts("| text files: OPEN <filenum>,<str_num_filename>,0|1: 0=read, 1=write   |");
   puts("| CLOSE <filenum>  READ|WRITE <filenum>,<str_num> [LET] <var>=<expr>   |");
   puts("| print <expr|string>[,<expr|string>][;]                               |");
   puts("| rem <anystring>  or ' <anystring>   LOCATE ycursor, xcursor          |");
   puts("| Operators: ^, * / \\ mod + - < <= > >= = <>, not, and, or            |");
   puts("| Integer variables a..z, and array @(expr); e.g.: @(0)=5:@(1)=7       |");
   puts("| Functions: abs(expr), asc(ch), rnd(expr), sgn(expr)                  |");
   puts("----------------------------------------------------------------------");
}

void gosubstmt(void) {      // for gosub: save the line and column
    gsp++;
    gstackln[gsp] = curline;
    gstacktp[gsp] = textp;
    gotostmt();
}

void range_err () {
    printf ("Error! String variable number not withing range(%d--->%d).",
	0, c_maxvars
    );
}

void inputstrstmt(void) {
   int var;

   var = expression(0);
   if ((var >= 0) && (var<=c_maxvars)) {
	 cprintf ("? ");
	 strcpy (strvars[var], mygetline(stdin));
   } else { range_err(); errors = true; }

   if (tracing) printf("\n*** %s = %s\n", varname[var], strvars[var]);
}

void midstrstmt(void) {
  int var;
  int s, n, c;

  var = expression(0);
  expect (',');
  s = expression(0);
  expect (',');
  n = expression (0);
  if ((var >= 0) && (var<=c_maxvars)) {
     for (c=0; c<n; c++) {
	strvars[var][c] = strvars[var][c+s-1];
     }
     strvars[var][c] = '\0';
  } else { range_err(); errors = true; }
}

void leftstrstmt(void) {
  int var;
  int t;

  var = expression(0);
  expect (',');
  t = expression (0);
  if ((var >= 0) && (var<=c_maxvars)) {
     strvars[var][t] = '\0';
  } else { range_err(); errors = true; }
}

void rightstrstmt(void) {
  int var;
  int t, c;
  char temp[255];

  var = expression(0);
  expect (',');
  t = expression (0);
  strcpy (temp, "");
  if ((var >= 0) && (var<=c_maxvars)) {
     for (c=0; c<t; c++) {
	temp[c] = strvars[var][c+(strlen(strvars[var])) - t];
     }
     temp[c] = '\0';
     strcpy (strvars[var], temp);
  } else { range_err(); errors = true; }
}

void printstrstmt(void) {
  int var;

  var = expression(0);
  if ((var >= 0) && (var<=c_maxvars)) {
      printer (strvars[var]);
  } else { range_err(); errors = true; }
}

void printchrstmt (void) {
   int var;

   var = expression (0);
   directvideo = false;
   cprintf ("%c", var);
   printf ("\n");
}

void assign(void) {
  int var;

  var = getvarindex();
  nexttok();
  expect(tEQUAL);
  vars[var] = expression(0);
  if (tracing) printf("\n*** %s = %d\n", varname[var], vars[var]);
}

void _peek(void) {
  int var, a,b;

  var = getvarindex();
  nexttok();
  expect(tEQUAL);
  a = expression(0);
  expect (',');
  b = expression (0);
  vars[var] = peekb (a, b);
  if (tracing) printf("\n*** %s = %d\n", varname[var], vars[var]);
}

void arrassn(void) {        // array assignment: @(expr) {} = expr
    int n, atndx;

    atndx = parenexpr();
    if (!accept(tEQUAL)) {
	printf("(%d, %d) Array Assign: Expecting '=', found: %s", curline, textp, thelin);
	errors = true;
    } else {
	n = expression(0);
	atarry[atndx] = n;
	if (tracing) printf("\n*** @(%d) = %d\n", atndx, n);
    }
}

void forstmt(void) {    // for i = expr to expr
    int var, forndx, n;

    var = getvarindex();
    assign();
    // vars(var) has the value; var has the number value of the variable in 0..25
    forndx = var;
    forvar[forndx] = vars[var];
    if (!accept(tTO)) {
	printf("(%d, %d) For: Expecting 'to', found: %d\n", curline, textp, tok);
	errors = true;
    } else {
	n = expression(0);
	forlimit[forndx] = n;
	// need to store iter, limit, line, and col
	forline[forndx] = curline;
	if (tok == tNONE) forpos[forndx] = textp; else forpos[forndx] = textp - 2;
	//forpos[forndx] textp; if (tok != "") forpos[forndx] -=2;
    }
}

void ifstmt(void) {
    need_colon = false;
    if (expression(0) == 0)
	skiptoeol();
    else {
	accept(tTHEN);      // "then" is optional
	if (tok == tNUMBER) gotostmt();
    }
}

void ifstreqstmt(void) {
    int a, b;

    need_colon = false;
    a = expression(0);
    expect(',');
    need_colon = false;
    b = expression(0);
    if (strcmp(strvars[a], strvars[b]) == 0)
	accept(tTHEN);      // "then" is optional
	if (tok == tNUMBER) gotostmt();
    else {
	skiptoeol();
    }
}

void ifstrnoteqstmt(void) {
    int a, b;

    need_colon = false;
    a = expression(0);
    expect(',');
    need_colon = false;
    b = expression(0);
    if (strcmp(strvars[a], strvars[b]) != 0)
	accept(tTHEN);      // "then" is optional
	if (tok == tNUMBER) gotostmt();
    else {
	skiptoeol();
    }
}

void ifstrsmallerstmt(void) {
    int a, b;

    need_colon = false;
    a = expression(0);
    expect(',');
    need_colon = false;
    b = expression(0);
    if (strcmp(strvars[a], strvars[b]) < 0)
	accept(tTHEN);      // "then" is optional
	if (tok == tNUMBER) gotostmt();
    else {
	skiptoeol();
    }
}

void ifstrbiggerstmt(void) {
    int a, b;

    need_colon = false;
    a = expression(0);
    expect(',');
    need_colon = false;
    b = expression(0);
    if (strcmp(strvars[a], strvars[b]) > 0)
	accept(tTHEN);      // "then" is optional
	if (tok == tNUMBER) gotostmt();
    else {
	skiptoeol();
    }
}

void inputstmt(void) {      // "input" [string ","] var
    int var;
    char *st, *endp;

    if (tok == tSTRING) {
	printer(&texttok[1]);
	nexttok();
	expect(tCOMMA);
    } else {
	printer ("? ");
    var = getvarindex();
    nexttok();
    st = mygetline(stdin);
    if (!st || st[0] == '\0')
      vars[var] = 0;
    else if (isdigit(st[0]))
      vars[var] = strtol(st, &endp, 10);
    else
      vars[var] = st[0]; // turn characters into their ascii value
    free(st);
    }
}

void screenstmt(void) {
    int graphicsdriver, graphicsmode;
    int var;

    var = expression (0);
    if (var==3) {
       textmode(C80);
       textbackground (BLACK);
       textcolor (LIGHTGRAY);
       clrscr();
       screenisvga = false;
       directvideo = false;
    } else
    if (var==13) {
       if (screenisvga == true) closegraph();
       graphicsdriver=MCGA; graphicsmode=MCGAC0;
       initgraph (&graphicsdriver, &graphicsmode, "tcbgi.bgi");
       screenisvga = true;
       directvideo = false;
    } else
    if (var==11) {
       if (screenisvga == true) closegraph();
       graphicsdriver=VGA; graphicsmode=VGAHI;
       initgraph (&graphicsdriver, &graphicsmode, "tcbgi.bgi");
       screenisvga = true;
       directvideo = false;
    }
}

void circlestmt(void) {
    int x,y, r;

    x = expression(0);
    expect (',');
    y = expression(0);
    expect (',');
    r = expression(0);
    if (screenisvga == true) {
	circle (x, y, r);
    }
}

void ellipsestmt(void) {
    int x,y, r, r2;

    x = expression(0);
    expect (',');
    y = expression(0);
    expect (',');
    r = expression(0);
    expect (',');
    r2 = expression(0);
    if (screenisvga == true) {
	ellipse (x, y, 0, 360, r, r2);
    }
}

void linestmt(void) {
   int a,b, c,d;

   a=expression(0);
   expect (',');
   b=expression(0);
   expect (',');
   c=expression(0);
   expect (',');
   d=expression(0);
   if (screenisvga == true) {
      line (a,b, c,d);
   }
}

void rectanglestmt(void) {
   int a,b, c,d;

   a=expression(0);
   expect (',');
   b=expression(0);
   expect (',');
   c=expression(0);
   expect (',');
   d=expression(0);
   if (screenisvga == true) {
      rectangle (a,b, c,d);
   }
}

void plotstmt(void) {
   int a,b;

   a=expression(0);
   expect (',');
   b=expression(0);
   if (screenisvga == true) {
      putpixel (a,b, getcolor());
   }
}

void inkstmt(void) {
   int c;

   c=expression (0);
   if (screenisvga==true) {
       setcolor (c);
   } else {
       textcolor (c);
   }
   directvideo = false;
}

void _poke(void) {
   int c, d, e;


   c=expression (0);
   expect (',');
   d=expression (0);
   expect (',');
   e=expression (0);
   pokeb (c, d, e);
}

void paperstmt(void) {
   int c;

   c=expression (0);
   if (screenisvga==true) {
       setbkcolor (c);
   } else {
       textbackground (c);
   }
   directvideo = false;

}


void fillstmt(void) {
   int x, y;

   x=expression (0);
   expect(',');
   y=expression (0);
   if (screenisvga==true) {
       floodfill (x, y, getcolor());
   }
   directvideo = false;

}

void beepstmt(void) {
    int x,y;

    x = expression(0);
    expect (',');
    y = expression(0);
    sound (x);
    delay (y);
    nosound();
}

void pausestmt(void) {
    int x;

    x = expression(0);
    delay (x);
}

void liststmt(void) {
    int i;
    char ch;

    for (i = 1; i < c_maxlines; ++i) {
	if (pgm[i]) printf("%d %s\n", i, pgm[i]);
/*	if ((i % 22) == 0) {
	   printf ("Scroll [y/n]?\n");
	   do {
	      ch = getch();
	   } while ((ch != 'Y') && (ch != 'y') && (ch != 'N') && (ch != 'n'));
	   if ((ch == 'N') || (ch == 'n')) goto Stophier;
	}
*/
    }
/*    Stophier:;*/
    printf("\n");
}

void loadstmt(void) {
    int n;
    char *filename;
    FILE *fp;

    newstmt();
    if ((filename = getfilename("Load")) == NULL) goto load_free;

    fp = fopen(filename, "r");
    if (fp == NULL) {
	printf("\nFile %s not found\n", filename);
	goto load_free;
    }

    n = 0;
    while ((pgm[0] = mygetline(fp)) != NULL) {
	initlex(0);
	if (tok == tNUMBER && validlinenum()) {
	    pgm[num] = strdup(pgm[0] + textp);
	    n = num;
	} else {
	    n++;
	    pgm[n] = strdup(pgm[0]);
	}
	free(pgm[0]);
    }
    fclose(fp);
load_free:
    free(filename);
    curline = 0;
}

void newstmt(void) {
    int i;

    clearvars();
    for (i = 0; i < c_maxlines; ++i) {
	if (pgm[i]) {free(pgm[i]); pgm[i] = NULL;}
    }
}

void nextstmt(void) {
    int forndx;

    // tok needs to have the variable
    forndx = getvarindex();
    forvar[forndx] = forvar[forndx] + 1;
    vars[forndx] = forvar[forndx];
    if (tracing) printf("\n*** %c = %d\n", forndx + 'a', vars[forndx]);
    if (forvar[forndx] <= forlimit[forndx]) {
	curline = forline[forndx];
	textp   = forpos[forndx];
	initlex2();
    } else
	nexttok(); //' skip the ident for now
}

void printstmt(void) {
    int printwidth, printnl = true;
    int var;

    while (tok != tCOLON && tok != tNONE) {
	printnl = true;
	printwidth = 0;

	if (accept(tPOUND)) {
	    if (num <= 0) {printf("\nExpecting a print width, found: %s\n", pgm[curline]); return;}
	    printwidth = num;
	    nexttok();
	    if (!accept(tCOMMA)) {printf("\nPrint: Expecting a ',', found: %s\n", pgm[curline]); return;}
	} else
	if (tok == tSTRING) {
	    cprintf ("%s", &texttok[1]);
	    nexttok();
	} else {
	    cprintf("%*d", printwidth, expression(0));
	}

	if (accept(tCOMMA) || accept(tSEMICOLOR)) {printnl = false;} else {break; }
    }
    if (printnl) printf("\n");
}

void letstr(void) {
    int printwidth;
    int var;
    char temp[255];
    int var0;

    strcpy (temp, "");
    var0=expression(0);
    expect(',');
    while (tok != tCOLON && tok != tNONE) {
//	printnl = true;
	printwidth = 0;

//      if (accept(tPOUND)) {
//      if (num <= 0) {cprintf("\nExpecting a print width, found: %s\n", pgm[curline]); return;}
//      printwidth = num;
//      nexttok();
//   if (!accept(tCOMMA)) {cprintf("\nPrint: Expecting a ',', found: %s\n", pgm[curline]); return;}
//      else
	if (tok == tSTRING) {
	    strcat (temp, &texttok[1]);
	    nexttok();
	} else {
	    cprintf("%*d", printwidth, expression(0));
	}

//   if (accept(tCOMMA) || accept(tSEMICOLOR)) {printnl = false;} else {break; }
    }

    strcpy (strvars[var0], temp);
//  if (printnl) printf("\n");
}

void openstmt(void) {
    int printwidth;
    int var;
    char temp[255];
    int var0;
    char filename[255];
    int modus;

    strcpy (temp, "");
    var0=expression(0); // file number .....
    expect(',');
    var=expression (0); // filename string number .... .... ...
    expect (',');
    modus = expression (0); // 0==read, 1==write, ..... .... .....
    if ((var0 >= 0) && (var0 <= 53)) {
       if (modus == 0) {
	   textfile[var0] = fopen(strvars[var], "r");
	   if (textfile[var0] == NULL) {
	       printf("\nFile %s could not be opend for writing\n", filename);
	   }
       } else
       if (modus == 1) {
	   textfile[var0] = fopen(strvars[var], "w");
	   if (textfile[var0] == NULL) {
	       printf("\nFile %s could not be opend for writing\n", filename);
	   }
       }
    }
}

void returnstmt(void) {     // return from a subroutine
    curline = gstackln[gsp];
    textp   = gstacktp[gsp];
    --gsp;
    initlex2();
}

void runstmt(void) {
    timestart = clock();
    clearvars();
    initlex(1);
}

void gotostmt(void) {
    num = expression(0);
    if (validlinenum()) initlex(num);
}

void savestmt(void) {
    int i;
    char *filename;
    FILE *fp;

    if ((filename = getfilename("Save")) == NULL) goto save_free;

    fp = fopen(filename, "w");
    if (fp == NULL) {
	printf("\nFile %s could not be opend for writing\n", filename);
	goto save_free;
    }

    for (i = 1; i < c_maxlines; ++i) {
	if (pgm[i])
	    fprintf(fp, "%d %s\n", i, pgm[i]);
    }
    fclose(fp);
save_free:
    free(filename);
}

void closestmt (void) {
    int nr;

    nr = expression(0);
    fclose (textfile[nr]);
}

void readstmt (void) {
    int a,b;

    a= expression (0);
    expect (',');
    b= expression (0);
    strcpy (strvars[b], mygetline(textfile[a]));
}

void writestmt (void) {
   int a,b;

   a= expression (0);
   expect (',');
   b= expression (0);
   fprintf (textfile[a], "%s\n", strvars[b]);
}

char *getfilename(char action[]) {
    char *filename;

    if (tok == tSTRING)
	filename = strdup(&texttok[1]);
    else {
	printf("\n%s: ", action);
	filename = mygetline(stdin);
    }
    if (!filename) return NULL;
    if (filename[0] == '\0') {
        free(filename);
        return NULL;
    }
    if (strchr(filename, '.') == NULL) {
        filename = realloc(filename, strlen(filename) + 5);
        strcat(filename, ".bas");
    }
    return filename;
}

bool validlinenum(void) {
    if (num <= 0 || num > c_maxlines) {
	printf("(%d, %d) Line number out of range", curline, textp);
	errors = true; return false;
    }
    return true;
}

void clearvars(void) {
    int i;

    for (i = 0; i < c_maxvars; ++i) {
	vars[i] = 0;
	strcpy (varname[i], "");
	strcpy (strvars[i], "");
    }
    gsp = 0;
    varptr = -1;
    fileptr = -1;
}

int getvarindex(void) {
    int c;

    if (tok != tIDENT) {
	printf("(%d, %d) Not a variable: %s\n", curline, textp, thelin);
	errors = true;
	return 0;
    }
    for (c=0; c<= varptr; c++) {
       if (strcmpi(varname[c], texttok) == 0) {
	   return (c);
       }
    }
    if (varptr < c_maxvars) {
       varptr++;
       strcpy (varname[varptr], texttok);
       return (varptr);
    }
    return (c_maxvars+1);
//    return texttok[0] - 'a';
}

bool expect(tok_t s) {
    if (!accept(s)) {
	printf("(%d, %d) Expecting %d, but found %d, %s\n", curline, textp, s, tok, thelin);
	return errors = true;
    }
    return false;
}

bool accept(tok_t s) {
    if (s == tok) {nexttok(); return true;}
    return false;
}

int expression(int minprec) {
    int n = 0;

    // handle numeric operands, unary operators, functions, variables
    if        (tok == tNUMBER)     { n = num; nexttok();
    } else if (tok == tMINUS)      { nexttok(); n = -expression(7);
    } else if (tok == tPLUS)       { nexttok(); n =  expression(7);
    } else if (tok == tNOT)        { nexttok(); n = !expression(3);
    } else if (tok == tABS)        { nexttok(); n = abs(parenexpr());
    } else if (tok == tASC)        { nexttok(); expect(tLP); n = texttok[1]; nexttok(); expect(tRP);
    } else if (tok == tRND || tok == tIRND) { nexttok(); n = rnd(parenexpr());
    } else if (tok == tSGN)        { nexttok(); n = parenexpr(); n = (n > 0) - (n < 0);
    } else if (tok == tIDENT)      { n = vars[getvarindex()]; nexttok();
    } else if (tok == tAMPERSAND)  { nexttok(); n = atarry[parenexpr()];
    } else if (tok == tLP)         { n = parenexpr();
    } else {
	printf("(%d, %d) Syntax error: expecting an operand, found: %d tok: %d\n", curline, textp, tok, tok);
        return n;
    }

    for (;;) {  // while binary operator and precedence of tok >= minprec
        if        (minprec <= 1 && tok == tOR)        { nexttok(); n = n | expression(2);
	} else if (minprec <= 2 && tok == tAND)       { nexttok(); n = n & expression(3);
        } else if (minprec <= 4 && tok == tEQUAL)     { nexttok(); n = n == expression(5);
        } else if (minprec <= 4 && tok == tLT)        { nexttok(); n = n <  expression(5);
        } else if (minprec <= 4 && tok == tGT)        { nexttok(); n = n >  expression(5);
        } else if (minprec <= 4 && tok == tNEQ)       { nexttok(); n = n != expression(5);
        } else if (minprec <= 4 && tok == tLEQ)       { nexttok(); n = n <= expression(5);
	} else if (minprec <= 4 && tok == tGEQ)       { nexttok(); n = n >= expression(5);
        } else if (minprec <= 5 && tok == tPLUS)      { nexttok(); n += expression(6);
        } else if (minprec <= 5 && tok == tMINUS)     { nexttok(); n -= expression(6);
        } else if (minprec <= 6 && tok == tMUL)       { nexttok(); n *= expression(7);
	} else if (minprec <= 6 && tok == tDIV)       { nexttok(); n /= expression(7);
        } else if (minprec <= 6 && tok == tBACKSLASH) { nexttok(); n /= expression(7);
        } else if (minprec <= 6 && tok == tMOD)       { nexttok(); n %= expression(7);
        } else if (minprec <= 8 && tok == tHAT)       { nexttok(); n = pow(n, expression(9));
	} else { break; }
    }
    return n;
}

int parenexpr(void) {
    int n = 0;

    if (!accept(tLP)) {
	printf("\n(%d, %d) Paren Expr: Expecting '(', found: %d\n", curline, textp, tok);
    } else {
	n = expression(0);
	if (!accept(tRP)) {
	    printf("\n(%d, %d) Paren Expr: Expecting ')', found: %d\n", curline, textp, tok);
        }
    }
    return n;
}

int rnd(int range) {
    return rand() % range + 1;
}

/* return null if nothing read */
char *mygetline(FILE *fp) {
    char *buf, *p;
    int size = BUFSIZ;

    p = buf = malloc(87);
    for (;;) {
	int c = fgetc(fp);
	if (c == EOF || c == '\n' || c == '\r') {   //@review: this isn't right - need to check for cr and lf
	    if (c == EOF && p == buf) {
		free(buf);
		return NULL;
	    }
	    *p = '\0';
	    return buf;
	}
	if (p - buf >= size) {
	    size += BUFSIZ;
	    buf = realloc(buf, size);
	}
	*p++ = (char)c;
    }
}

void initlex(int n) {
    curline = n;
    textp = 0;
    initlex2();
}

void initlex2(void) {
    need_colon = false;
  thelin = pgm[curline];
  thech = ' ';
  nexttok();
}

void nexttok(void) {
    tok = tNONE;
    begin: texttok[0] = thech; _getch();
    if (texttok[0] == '\0') { ;
    } else if (isspace(texttok[0])) { goto begin;
    } else if (isalpha(texttok[0])) { readident(); if (streql(texttok, "rem")) skiptoeol();
    } else if (isdigit(texttok[0])) { readint();
    } else if (texttok[0] == '"')  { readstr();
    } else if (texttok[0] == '\'')  { skiptoeol();
    } else if (strchr("#()*+,-/:;<=>?@\\^", texttok[0]) != NULL) {
	tok = texttok[0]; texttok[1] = texttok[2] = '\0';
	if (texttok[0] == '<' && thech == '>') {
	    tok = tNEQ; texttok[1] = thech; _getch();
	} else if (texttok[0] == '<' && thech == '=') {
	    tok = tLEQ; texttok[1] = thech; _getch();
	} else if (texttok[0] == '>' && thech == '=') {
	    tok = tGEQ; texttok[1] = thech; _getch();
	}
    } else {
	printf("(%d, %d) What? %c (%d) %s\n", curline, textp, texttok[0], texttok[0], thelin);
	_getch();
	errors = true;
    }
}

void skiptoeol(void) {
    tok = tNONE;
    textp = strlen(thelin) + 1;
}

// store double quote as first char of string, to distinguish from idents
void readstr(void) {
    char *p = &texttok[1];
    tok = tSTRING;
    while (thech != '"') {
	if (thech == '\0') {
	    printf("(%d, %d) String not terminated\n", curline, textp);
	    errors = true;
	    return;
	}
	*p++ = thech;
	_getch();
    }
    *p = '\0';
    _getch();
}

void readint(void) {
    char *p = &texttok[1], *endp;
    tok = tNUMBER;
    while (isdigit(thech)) {
        *p++ = thech;
	_getch();
    }
    *p = '\0';
    num = strtol(texttok, &endp, 10);
}

typedef struct {
    const char *s;
    tok_t tok;
} KWT;

void readident(void) {
    KWT kwds[] = {
	{"abs",     tABS},
	{"and",     tAND},
	{"asc",     tASC},
	{"bye",     tBYE},
	{"clear",   tCLEAR},
	{"cls",     tCLS},
	{"end",     tEND},
	{"for",     tFOR},
	{"gosub",   tGOSUB},
	{"goto",    tGOTO},
	{"help",    tHELP},
	{"if",      tIF},
	{"ifstreq", tIFSTREQ},
	{"ifstrsmaller", tIFSTRSMALLER},
	{"ifstrbigger",  tIFSTRBIGGER},
	{"ifstrnoteq",   tIFSTRNOTEQ},
	{"input",   tINPUT},
	{"inputstr",  tINPUTSTR},
	{"readkey",   tREADKEY},
	{"inkey",     tINKEY},
	{"beep",      tBEEP},
	{"pause",     tPAUSE},
	{"pauze",     tPAUSE},
	{"open",      tOPEN},
	{"close",     tCLOSE},
	{"read",      tREAD},
	{"write",     tWRITE},
	{"irnd",    tIRND},
	{"let",     tLET},
//      {"peek",    tPEEK},
	{"poke",    tPOKE},
	{"letstr",    tLETSTR},
	{"list",    tLIST},
	{"load",    tLOAD},
	{"mod",     tMOD},
	{"new",     tNEW},
	{"next",    tNEXT},
	{"not",     tNOT},
	{"or",      tOR},
	{"print",   tPRINT},
	{"printstr",  tPRINTSTR},
	{"printchr",  tPRINTCHR},
	{"printchar", tPRINTCHR},
	{"midstr",  tMIDSTR},
	{"leftstr", tLEFTSTR},
	{"rightstr", tRIGHTSTR},
	{"quit",    tQUIT},
	{"rem",     tREM},
	{"return",  tRETURN},
	{"rnd",     tRND},
	{"randomize", tRANDOMISE},
	{"randomise", tRANDOMISE},
	{"run",     tRUN},
	{"save",    tSAVE},
	{"sgn",     tSGN},
	{"stop",    tSTOP},
	{"then",    tTHEN},
	{"to",      tTO},
	{"troff",   tTROFF},
	{"tron",    tTRON},
	{"screen",  tSCREEN},
	{"line",    tLINE},
	{"circle",  tCIRCLE},
	{"rectangle", tRECTANGLE},
	{"ellipse", tELLIPSE},
	{"plot",    tPLOT},
	{"ink",     tINK},
	{"paper",   tPAPER},
	{"fill",    tFILL},
	{"locate",  tLOCATE}
    };
    unsigned i;
    char *p = &texttok[1];
    texttok[0] = tolower(texttok[0]); tok = tIDENT;
    while (isalnum(thech)) {
	*p++ = tolower((char)thech);
	_getch();
    }
    *p = '\0';
    for (i = 0; i < NELEMS(kwds); ++i) {
	if (streql(texttok, kwds[i].s)) {
	    tok = kwds[i].tok;
	    break;
	}
    }
}

void _getch(void) {
    if (!thelin) {
	thech = '\0';
    } else {
	thech = thelin[textp];
	if (thech != '\0')
	    ++textp;
    }
}

void readkeystmt(void) {
    int var;

    var = getvarindex();
    nexttok();
    vars [var] = getch();
}

void inkeystmt(void) {
    int var;

    var = getvarindex();
    nexttok();
    if (kbhit()) {
       vars[var] = getch();
    } else vars[var] = -1;
}

void randomizestmt (void) {
   randomize();
}

void locatestmt(void) {
   int y,x;

   y= expression (0);
   expect (',');
   x= expression (0);
   directvideo=false;
   gotoxy (x, y);
}
