{$i-}

program TurboForthCompiler (input, output);

uses
  crt;

var
  T               : text;
  Tekst, Tekst2   : string;
  Line            : string;
  F,F2            : file;
  B               : byte;
  c               : longint;
  x, y            : longint;
  q               : longint;

begin
  nosound;
  if paramcount < 1 then begin
    writeln;
    textcolor (lightred);
    writeln ('Turbo Forth Command Line Compiler.');
    writeln ('This program makes an exe-file from your Turbo Forth source code.');
    writeln;
    textcolor (lightgreen);
    writeln ('This program uses "RUNFORTH.TFL", turbo forth runtime library...');
    writeln;
    textcolor (white);
    writeln ('Usage: ', paramstr (0), ' <Turbo_Forth_text_source_code_file>[.4TH] ..');
    writeln;
    textcolor (lightgray);
    halt (23)
  end;
  textcolor (yellow);
  Tekst:= paramstr (1);
  if pos ('.', Tekst) = 0 then Tekst:= concat (Tekst, '.4TH');
  Tekst2:= copy (Tekst, 1, pos ('.', Tekst)-1) + '.EXE';
  writeln ('Compiling: ', Tekst, ' ... .... ...');
  assign (T, Tekst);
  reset (T);
  if ioresult <> 0 then begin
    writeln;
    textcolor (red);
    writeln ('Error: ', Tekst, ' not found.');
    writeln;
    textcolor (lightgray);
    halt (25);
  end;
  assign (F, 'RUNFORTH.TFL');
  reset (F, 1);
  if ioresult <> 0 then begin
    writeln;
    textcolor (red);
    writeln ('Error: ', ' "RUNFORTH.TFL" - library not found.');
    writeln;
    textcolor (lightgray);
    halt (27);
  end;
  assign (F2, Tekst2);
  rewrite (F2, 1);
  for c:= 1 to filesize (F) do begin
    blockread (F, B, 1);
    blockwrite (F2, B, 1);
  end;
  close (F);
  x:= wherex;
  y:= wherey;
  readln (T, Line);
  c:= 1;
  while not eof (T) do begin
    gotoxy (x, y);
    write ('Compiling line: ', c : 7);
    for q:= length(Line)+1 to 255 do Line:= Line + ' ';
    blockwrite (F2, Line[0], 256);
    readln (T, Line);
    inc (c, 1);
  end;
  gotoxy (x, y);
  write ('Compiling line: ', c : 7);
  for q:= length(Line)+1 to 255 do Line:= Line + ' ';
  blockwrite (F2, Line[0], 256);
  writeln;
  close (T);
  close (F2);
  textcolor (lightgray);
  writeln ('All done!');
  halt (0)
end.
+
+
+
+
